%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: save_results
%
% Scope:    write results (mean, st_dev, uncertainty) to text files
%
% Input:    data (structure),
%           binref (structure),
%           uncert (structure),
%           list of gas names (cell),
%           output file name (string)
%
% Output:   results written to text files
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function save_results(data,binref,uncert,gasnames,output_file_name)

tic;fprintf('Running function save_results...\n');

%% remove empty elements in binref.gastype

emptycells = cellfun(@isempty,binref.gastype);
binref.gastype(emptycells)={'NaN'};
 
 %% recalculate d15N_bulk (mean value)
 
 binref.mean(:,3)=(binref.mean(:,4)+binref.mean(:,5))./2;
 
for i=1:width(gasnames)
    binref.(gasnames{1,i})(1,3)=(binref.(gasnames{1,i})(1,4)+binref.(gasnames{1,i})(1,5))./2;
end

%% write output files

file_name_mean_intervals=[output_file_name '_intervals_mean.txt'];
file_name_stdev_intervals=[output_file_name '_intervals_stdev.txt'];
file_name_mean_gastypes=[output_file_name '_gastypes_mean.txt'];
file_name_stdev_gastypes=[output_file_name '_gastypes_stdev.txt'];

file=fopen(file_name_mean_intervals,'w');
fprintf(file,'Interval No., Gastype, Time [h], N2O [ppb], d15N [permil], d15Na [permil], d15Nb [permil], d18O [permil], pCell [mTorr], TCell [°C], TChiller [°C], TP9 [°C], CH4 [ppm], CO [ppm], CO2 [ppm], H2O [%%], IntervalDuration [min]\n');
for i=1:height(binref.gastype)
    fprintf(file, '%1.0f, %s, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f\n',i, string(binref.gastype(i,1)), binref.mean(i,1:10),binref.mean(i,12:15),data.interval_duration(i,1));
end
fclose(file);

file=fopen(file_name_stdev_intervals,'w');
fprintf(file,'Interval No., Gastype, Time [h], N2O [ppb], d15N [permil], d15Na [permil], d15Nb [permil], d18O [permil], pCell [mTorr], TCell [°C], TChiller [°C], TP9 [°C], CH4 [ppm], CO [ppm], CO2 [ppm], H2O [%%], IntervalDuration [min]\n');
for i=1:height(binref.gastype)
    fprintf(file, '%1.0f, %s, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f\n',i, string(binref.gastype(i,1)), binref.std(i,1:10),binref.std(i,12:15),data.interval_duration(i,1));
end
fclose(file);

file=fopen(file_name_mean_gastypes,'w');
fprintf(file,'Gastype, N2O [ppb], d15N [permil], d15Na [permil], d15Nb [permil], d18O [permil], pCell [mTorr], TCell [°C], TChiller [°C], TP9 [°C], CH4 [ppm], CO [ppm], CO2 [ppm], H2O [%%]\n');
for i=1:width(gasnames)
    fprintf(file,'%s, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f\n',string(gasnames(1,i)), binref.(gasnames{1,i})(1,2:10),binref.(gasnames{1,i})(1,12:15));
    %fprintf(file,'%s_stdev, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f\n',string(gasnames(1,i)), binref.(gasnames{1,i})(2,2:10),binref.(gasnames{1,i})(2,12:15));
end
fclose(file);

file=fopen(file_name_stdev_gastypes,'w');
fprintf(file,'Gastype, N2O [ppb], d15N [permil], d15Na [permil], d15Nb [permil], d18O [permil], pCell [mTorr], TCell [°C], TChiller [°C], TP9 [°C], CH4 [ppm], CO [ppm], CO2 [ppm], H2O [%%]\n');
for i=1:width(gasnames)
    %fprintf(file,'%s_mean, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f\n',string(gasnames(1,i)), binref.(gasnames{1,i})(1,2:10),binref.(gasnames{1,i})(1,12:15));
    fprintf(file,'%s, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f\n',string(gasnames(1,i)), binref.(gasnames{1,i})(2,2:10),binref.(gasnames{1,i})(2,12:15));
end
fclose(file);

%% write output files (uncert)

if uncert.check == 1

    file_name_uncert_intervals=[output_file_name '_intervals_uncert.txt'];
    file_name_uncert_gastypes=[output_file_name '_gastypes_uncert.txt'];

    % Write to file (gastypes)
    file=fopen(file_name_uncert_gastypes,'w');
    fprintf(file,'Gastype, Isotopologue, Uncert_N2O_Corr [permil], Uncert_CH4_Corr [permil], Uncert_CO2_Corr [permil], Uncert_Calib_Corr [permil], Uncert_Other_Effects [permil], Uncert_Total [permil]\n');
    for i=1:width(gasnames)
        fprintf(file,'%s, alpha, %f, %f, %f, %f, %f, %f \n',string(gasnames(1,i)),uncert.mean.(gasnames{1,i})(1,:));
        fprintf(file,'%s, beta, %f, %f, %f, %f, %f, %f \n',string(gasnames(1,i)),uncert.mean.(gasnames{1,i})(2,:));
        fprintf(file,'%s, 18O, %f, %f, %f, %f, %f, %f \n',string(gasnames(1,i)),uncert.mean.(gasnames{1,i})(3,:));
    end
    fclose(file);

    % Write to file (intervals)
    file=fopen(file_name_uncert_intervals,'w');
    fprintf(file,'Interval No., Gastype, Time [h], Isotopologue, Uncert_N2O_Corr [permil], Uncert_CH4_Corr [permil], Uncert_CO2_Corr [permil], Uncert_Calib_Corr [permil], Uncert_Total [permil], IntervalDuration [min]\n');
    for i=1:height(binref.gastype)
        fprintf(file, '%1.0f, %s, %f, alpha, %f, %f, %f, %f, %f, %f \n',i, string(binref.gastype(i,1)), binref.mean(i,1), uncert.mean.alpha(i,:));
        fprintf(file, '%1.0f, %s, %f, beta, %f, %f, %f, %f, %f, %f \n',i, string(binref.gastype(i,1)), binref.mean(i,1), uncert.mean.beta(i,:));
        fprintf(file, '%1.0f, %s, %f, 18O, %f, %f, %f, %f, %f, %f \n',i, string(binref.gastype(i,1)), binref.mean(i,1), uncert.mean.o18(i,:));
    end
    fclose(file);

end

%%
time_elapsed=toc; fprintf('save_results completed (execution time: %1.2f s)\n',time_elapsed); 

end

